Review

# Wearable Health Devices in Health Care: Narrative Systematic Review

Lin Lu\*, MD; Jiayao Zhang\*, MD; Yi Xie\*, MD; Fei Gao, MD; Song Xu, MD; Xinghuo Wu, MD; Zhewei Ye, Prof Dr, MD

Department of Orthopaedic Surgery, Union Hospital, Tongji Medical College, Huazhong University of Science and Technology, Wuhan, China \*these authors contributed equally

# Corresponding Author:

Zhewei Ye, Prof Dr, MD   
Department of Orthopaedic Surgery   
Union Hospital, Tongji Medical College   
Huazhong University of Science and Technology   
1277 Jiefang Dadao   
Wuhan, 430022   
China   
Phone: 86 17771413685   
Email: yezhewei@hust.edu.cn

# Abstract

Background: With the rise of mobile medicine, the development of new technologies such as smart sensing, and the popularization of personalized health concepts, the field of smart wearable devices has developed rapidly in recent years. Among them, medical wearable devices have become one of the most promising fields. These intelligent devices not only assist people in pursuing a healthier lifestyle but also provide a constant stream of health care data for disease diagnosis and treatment by actively recording physiological parameters and tracking metabolic status. Therefore, wearable medical devices have the potential to become a mainstay of the future mobile medical market.

Objective: Although previous reviews have discussed consumer trends in wearable electronics and the application of wearable technology in recreational and sporting activities, data on broad clinical usefulness are lacking. We aimed to review the current application of wearable devices in health care while highlighting shortcomings for further research. In addition to daily health and safety monitoring, the focus of our work was mainly on the use of wearable devices in clinical practice.

Methods: We conducted a narrative review of the use of wearable devices in health care settings by searching papers in PubMed, EMBASE, Scopus, and the Cochrane Library published since October 2015. Potentially relevant papers were then compared to determine their relevance and reviewed independently for inclusion.

Results: A total of 82 relevant papers drawn from 960 papers on the subject of wearable devices in health care settings were qualitatively analyzed, and the information was synthesized. Our review shows that the wearable medical devices developed so far have been designed for use on all parts of the human body, including the head, limbs, and torso. These devices can be classified into 4 application areas: (1) health and safety monitoring, (2) chronic disease management, (3) disease diagnosis and treatment, and (4) rehabilitation. However, the wearable medical device industry currently faces several important limitations that prevent further use of wearable technology in medical practice, such as difficulties in achieving user-friendly solutions, security and privacy concerns, the lack of industry standards, and various technical bottlenecks.

Conclusions: We predict that with the development of science and technology and the popularization of personalized health concepts, wearable devices will play a greater role in the field of health care and become better integrated into people’s daily lives. However, more research is needed to explore further applications of wearable devices in the medical field. We hope that this review can provide a useful reference for the development of wearable medical devices.

(JMIR Mhealth Uhealth 2020;8(11):e18907) doi: 10.2196/18907

# Introduction

# Background

In the 1960s, the concept of wearable technology was first proposed by Edward O Thorp [1], a mathematics professor at the Massachusetts Institute of Technology in the United States. Since then, wearable technology has received considerable attention from researchers all around the world. In recent years, with the development of the internet, intelligent hardware, and big data, wearable technology has developed rapidly in various fields such as health care [2], education and culture [3], social networking [4], and the military [5]. Some of these technologies are becoming part of people’s daily life in the form of accessories such as smart watches, smart bracelets, armbands, and glasses [6]. In the field of health care, wearable devices in the form of portable medical or health electronic devices that can be directly worn on the body can be used to perceive, record, analyze, regulate, and intervene to maintain health and can even be used to treat diseases with the support of various technologies for identification, sensing, connection, cloud services, and storage [7]. By intelligently integrating mechanical functions with microelectronics and computing power, wearable devices can be used to achieve immediate detection of patient signs and laboratory indicators and provide exercise guidance, drug administration reminders, and so on, with the aim of achieving multiparameter, real-time, online, accurate and intelligent detection and analysis of human physiological and pathological information that can be used to carry out self-diagnosis and self-monitoring [8].

As a standard health care intervention, there are 5 main features of wearable devices [9]: (1) wireless mobility; (2) interactivity and intelligence; (3) sustainability and durability; (4) simple operation and miniaturization; and (5) wearability and portability. From the perspective of modern medicine, the application of wearable devices in the field of medicine follows the 4P medical model characterized by preventive, predictive, personalized, and participatory medicine [10]. On one hand, wearable technologies will play a significant role in advancing precision medicine by enabling measurement of clinically relevant parameters showing the health status of individuals [11]. On the other hand, Loncar-Turukalo et al [12] also indicated that wearable medical devices play an important role as an enabling technology and as a key driver that facilitated the emergence of connected health care. The operation and implementation of these devices depend on the application of various wearable technologies, including sensor technology, medical chip technology, wireless communication technology, power management technology, display technology, and information feedback technology [13]. Real-time medical data from these devices are transmitted to the internet for further analyses or feedback from a health care provider.

# Objectives

The development of wearable sensors in the health care market has been relatively slow, despite wearable devices having emerged as a major part of lifestyle and fitness markets. However, the advancement of wearable sensor technology provides enormous opportunities for deployment in health care, especially in connected health care and precision medicine, in which wearable devices can achieve high-quality, real-time measurement of personal health. Although previous reviews have discussed consumer trends in wearable electronics and the application of wearable technology in recreational and sporting activities, data on broad clinical usefulness are lacking. This study reviews the current application of wearable devices in health care. In addition to daily health and safety monitoring, the focus of our work is mainly on the use of wearable devices in clinical practice. We also emphasize their current shortcomings and suggest directions for further research.

# Methods

# Design

A systematic review design with narrative methods was used to analyze the existing evidence. Specifically, a review methodology [14] was carried out to clarify the types of wearable devices and the current status of their use in health care settings.

# Search Strategy

We conducted a comprehensive literature search on January 2, 2020. The following electronic databases were searched with the assistance of an information specialist at the medical library: PubMed, EMBASE, Scopus, and the Cochrane Library. The review was limited to texts published in English between 2015 and 2019 for which abstracts were available. These publication years were chosen due to a dramatic improvement in information technology during that period. The review was also limited to studies of wearable devices in the health care domain. The initial search terms were the following: wearable devices AND health care, wearable technology AND health care, sensor AND wearable AND health care, and wearable AND track AND health care. After reviewing the literature identified through these search terms, we added the search terms monitoring, diseases management, diagnosis OR treatment, and rehabilitation to capture relevant studies found in the references of the papers retrieved from the initial search.

# Inclusion and Exclusion Criteria

A total of 960 search results were screened for relevance using titles and abstracts, and 82 papers were fully reviewed and are discussed in this study.

Inclusion research criteria were (1) trials including randomized clinical trials and quasi-experimental studies that have proven the effectiveness of wearable devices; (2) studies focusing on clinical applicability; (3) studies published in peer-reviewed journal in English; (4) studies describing completed research; and (5) studies described in full-text papers. There was no restriction on the location of the studies; therefore, international studies written in English were eligible. Exclusion criteria were papers describing the process of the wearable device design, theoretical papers, books or book chapters, letters, statistical reviews, perspectives, dissertations, editorials, and study protocols.

# Study Selection

The research screening process consisted of 4 steps. First, 3 authors (LL, ZJY, and XY) independently screened all titles and abstracts of relevance for this systematic review. Second, the abstracts of all relevant papers were screened for eligibility by the 3 authors. Third, the full texts of eligible publications were obtained and screened (LL) according to the inclusion and exclusion criteria. Differences in opinion were resolved by discussing until a consensus was reached. Finally, to avoid incomplete searching, the references of recent related reviews and the primary studies were manually screened for eligible studies.

# Results

![](images/39fe89bc7610298092d6841d77b709f758aa949af12c3ef5fd47498590e604d8.jpg)  
Figure 1. The flow diagram illustrating the screening process of papers.

After reviewing the title and abstract, the search identified 960 potentially relevant documents. Among them, 82 papers met the inclusion criteria after full-text review (Figure 1).

# Classification of Wearable Devices

Wearable devices developed so far have been designed for use on all parts of the human body and are classified into 3 categories: head, limb, and torso wearable devices [15].

Head wearable devices mainly include glasses, helmets, headbands, hearing aids, earrings, earphones, and patches [12]. Among them, Google Glass is a representative type of smart glasses, which has functions such as taking photos, video calls, and GPS positioning, while the application of virtual reality (VR), augmented reality, and mixed reality technology make it suitable for use in areas such as telemedicine, medical education, and intraoperative navigation [16].

Limb wearable devices mainly include wearable devices worn on the arms, legs, and feet [17,18]. Most of the devices worn on the upper limbs are smart watches, bracelets, and other accessories that can be used to monitor physiological parameters such as body temperature, heart rate, ultraviolet exposure levels, and daily activities [19]. Most of the devices worn on the lower limbs appear in the form of shoes and socks that monitor movement-related parameters and are mainly used in the field of rehabilitation [20].

Torso wearable devices mainly include suits, belts, and underwear [21,22]. In recent years, the rapid development of material technology and sensing technology has facilitated the manufacture of electronic products embedded in fabrics or other fabrics that can be used in various biomedical applications. In

2009, a system of clothing providing access to the internet was developed by the Media Technology Laboratory of the Massachusetts Institute of Technology and marked the arrival of a new era of electronic textiles [23].

# Application of Wearable Devices in the Medical Field

In the medical field, wearable devices can connect doctors, patients, clouds, and other parties to understand changes in conditions, to alleviate pain, treat diseases, and facilitate the collection of a large sample of case data, which is helpful for the development of national epidemiology strategies and preventive medicine [24]. These devices are used mainly in health and safety monitoring [25], chronic disease management [26], disease diagnosis and treatment [27], and rehabilitation [28].

# Health and Safety Monitoring

The health and safety monitoring function of wearable devices is mainly used for older adults, children, pregnant women, and patient groups. The wearer’s gait, walking speed, posture, respiratory rate, blood oxygen, heart rate, blood pressure, energy expenditure, position, and other related parameters are monitored in real time to inform nursing requirements [29]. For older adults, a high-quality independent life requires solutions to complex nursing needs related to mobility, intelligence, and independent living, which can be provided by the characteristics of wearable technology [30]. Godfrey et al [31] used wearable devices for gait and fall quantification in older adults, monitoring the viability of older adults’ daily activities in an unattended home environment and recognizing the main types of movement (walking, standing, sitting, lying) to help older adults to live independently. Jung et al [32] developed a wearable fall detection system to detect falls by rapidly uploading data for the position of older adult individuals to the medical center and ensuring timely help and treatment. For children, in addition to detecting routine vital signs for health management, wearable technology is a useful tool for tracking children's daily activities [33]. With the rise of wearable devices, children’s smart watches, bracelets, and backpacks with tracking and positioning functions have emerged in the market. These devices are based on GPS positioning technology to monitor the child’s location and amount of exercise in real time [34]. Furthermore, wearable technology can also be used to monitor mood. Sequeira et al [35] have demonstrated the feasibility of wearable tools in the prediction of depressive symptoms in children and adolescents. Health monitoring of pregnant women can be divided into 2 aspects [36]. On one hand, these applications can be used to monitor the physiological status, emotional state, sleep, and other data before and after conception, while on the other hand, devices can be used to provide immediate feedback on specific problems that occur in the process of child-rearing. Head-med’s Compass Pregnancy Monitor [37] is the first medical-grade fetal health home monitoring product that is easy to operate and monitors maternal heart rate, fetal heart rate, and uterine activity through a disposable abdominal patch. For patient groups, wearable devices can be used to monitor symptom changes during treatment, which can be used for disease monitoring and efficacy evaluations and can contribute to individualization of the treatment plan [29]. For example, wearable sensors can be used to monitor the symptoms of patients with Parkinson disease during drug treatment to help doctors adjust drug doses and evaluate the efficacy of new drugs [38]. van Andel et al [39] used photoplethysmography in heart rate monitoring of patients with epilepsy and showed excellent seizure detection performance. Ryvlin et al [40] developed a wearable device that reliably detects generalized tonic-clonic seizures with high sensitivity and specificity to help physicians optimize antiepileptic treatment and reduce the risk of sudden unexpected death in epilepsy.

# Chronic Disease Management

# Overview

Chronic disease management involves changing passive disease treatment into active health monitoring [41]. Wearable products facilitate data collection and monitoring throughout the user’s entire day, as well as providing dynamic, intelligent, and comprehensive analysis of various indicators to enable medical treatment of chronically ill patients. This technology also facilitates remote monitoring of diseases, adjustment of remote treatment plans, lifestyle management, and other functions through cloud services, which is of great significance in disease control [42].

# Cardiovascular Disease

Cardiovascular diseases can be easily overlooked, with sudden and potentially lethal consequences that require emergency treatment [43]. They are often accompanied by changes in myocardial electrophysiology at an early stage [44]. Therefore, improving daily monitoring is important for discovering and controlling heart disease. There are 2 kinds of traditional cardiovascular disease monitoring: invasive and noninvasive. For routine monitoring, noninvasive electrocardiograms (ECG) and Doppler echocardiography are the main means of examining cardiac function [45]. The 24-hour ambulatory ECG (Holter monitor), which is a relatively mature wearable medical device currently used in the clinic, allows dynamic monitoring, which conventional ECG does not. However, due to suboptimal wearing comfort and the fact that the conductive gel used with electrodes can lead to chest skin allergies and ulcers, its application in home-based daily monitoring is limited. Ultrasonic heart examination can only be used in a hospital setting [46]. To allow people to manage their own health, researchers at home and abroad have conducted many studies on wearable health monitoring systems, especially for ECG long-term data collection. Tsukada et al [47] developed a sports vest made from nanofibers coated with an electroconductive polymer to place the ECG electrodes in close contact with the human body. The signal allows display of the ECG signal in real time, and the monitoring data are collected through an app, which increases comfort without risking allergies. The data are uploaded to the cloud and analyzed by a professional physician to realize remote monitoring of heart diseases. In December 2018, Apple developed the Apple Watch Series 4, which combined the functions of ECG and a watch for the first time. In addition, the dial was designed to display a bipolar ECG to monitor occult atrial fibrillation. This device shows similar accuracy in monitoring arrhythmia, atrioventricular block, and

QRS duration extension to standard 12-lead ECG recordings [48]. Kaspar et al [49] found that the use of a wearable cardioverter-defibrillator protected patients from sudden cardiac arrest when they were treated in nonhospital settings until reimplantation of an implantable cardioverter-defibrillator.

# Pulmonary Diseases

Acute exacerbations of chronic obstructive pulmonary disease (COPD) and bronchial asthma can lead to impaired lung function, decreased quality of life, and increased mortality [50]. Active monitoring of the early signs of a patient’s condition and early treatment can prevent these outcomes. The telehealth program aims to facilitate early identification and timely self-management of acute exacerbations of COPD and bronchial asthma [51]. For such patients, early detection of progression can help to control the disease [52]. The emergence of inexpensive wearable devices has enabled people to monitor heart rate, pulse, oxygen saturation, and physical activity continuously, as well as audio to detect cough, breath sounds, and other characteristics [53]. These signals can be used in predictive analyses to detect early deterioration of lung function. A prospective cohort study [54] conducted at the University of Toronto evaluated a wearable system that reliably captured nearly continuous patient respiratory rate, oxygen saturation, heart rate, and other data for screening of early COPD deterioration. The results of this study demonstrated the feasibility of using a smart watch for centralized monitoring of patients with COPD. A wearable device developed by Colantonio et al [55] uses a wireless sensor network system to monitor the patient’s respiratory rate, respiratory sound, blood oxygen saturation, and ECG to evaluate the therapeutic effect of treatments for COPD. Li et al [56] used acoustic respirators to monitor nighttime wheezing in asthmatic children and found that $5 7 \%$ of patients with well-controlled asthma had a significant number of nighttime wheezing episodes and poor association with routine measurements of lung function. This has helped to develop individualized treatment for children with asthma. However, Rubio et al [51] reported disappointing results for the use of wearable devices to monitor acute exacerbations of COPD, in part because the parameters monitored (symptoms, pulse oximetry, and lung volume) were not reliable indicators for predicting exacerbation of the disease. It should be pointed out that with advances in sensing technology, wearable systems can also link individual environmental exposure with physiology and subsequent adverse health reactions, providing clues for the pathogenesis of certain lung diseases [57].

# Diabetes

Diabetes represents a group of metabolic diseases characterized by hyperglycemia caused by defects in insulin secretion or impaired biological effects [58]. Long-term poor glycemic control can lead to damage, dysfunction, and failure of various organ tissues, especially the eyes, kidneys, nerves, heart, and blood vessels [59]. For patients with diabetes, improving the ability of self-monitoring and self-management of blood glucose levels has contributed to the reduction of diabetes-related morbidity and mortality. There are currently 3 types of medical management products on the market for patients with diabetes: blood glucose level monitoring equipment, injectable insulin, and implantable insulin pumps [60]. Among them, blood glucose level monitoring products have an important position in blood glucose level control, which is the basic reference for the adjustment of other treatment methods and can also prevent the occurrence of risk events [61]. Traditional blood glucose level monitoring is performed by directly drawing a venous blood sample or taking a finger-prick blood sample, which is analyzed by a biochemical analyzer. These methods are invasive and inconvenient, especially for patients with diabetes who need to monitor blood glucose level several times a day. Due to the volatility and transience of blood glucose level testing, traditional single-point testing methods do not truly reflect the changes in glucose levels in the body [62]. With the development of mobile and sensor technologies, wearable dynamic blood glucose level monitoring products have emerged. The GlucoWatch [61], a noninvasive, painless blood glucose level monitoring product approved by the US Food and Drug Administration in March 2001, has proven its applicability and feasibility in the field of diabetes monitoring products. At present, wearable medical devices widely use indirect measurement methods (minimally invasive or noninvasive) to measure parameters such as blood glucose concentration. The main methods are spectrometry, blood substitution (urine, tears, and tissue fluid), counter-ion electroosmosis, and microwave technology [63,64]. Compared with other methods, the optical method is rapid, is noninvasive, is nonpolluting, is simple to operate, and has become the main method for noninvasive blood glucose level detection. The principle of the measurement is based on concentration-dependent changes in the absorption and reflection characteristics of glucose [65]. However, the accuracy of the measurement is limited by the overlap of other blood components absorption spectra with the absorption spectrum of glucose [64]. In addition, Medtronic’s Minimed 670G uses a portable design to integrate blood glucose level monitoring and an insulin pump. The patient can affix the device to the waist and set the daily detection and injection times. Pillalamarri et al [66] developed a handheld insulin pump using biomedical microelectromechanical systems technology to intelligently control the rate and volume of insulin injections, maintaining blood glucose level within a relatively stable range.

# Hypertension

Hypertension is a chronic disease characterized by a sustained increase in arterial blood pressure. It is the most important risk factor for cardiovascular and cerebrovascular diseases, which seriously endanger human health [67]. Therefore, the accuracy and reliability of blood pressure measurement during the diagnosis and treatment of hypertension is especially important [68]. Blood pressure can be measured directly and indirectly [69]. Direct measurement involves percutaneous puncture and catheterization of the aorta. This is an invasive method and is only applicable in critical and difficult cases. Indirect measurement, also known as cuff compression, involves the use of a sphygmomanometer. This is the most commonly used measurement method, but continuous data cannot be obtained [70]. Noninvasive continuous blood pressure measurement is the trend for the development of wearable blood pressure monitors. At present, wearable devices determine blood pressure by measuring different physiological signals and can be divided into 4 types according to the principle [71]: (1) flattening tension of the radial artery; (2) volume changes in pulsing blood; (3) speed of pulse wave; and (4) the vibration measurement method. Moreover, wearable blood pressure monitor can be roughly divided into 2 types according to structure: cuff type and sleeveless type. Due to its strong anti-interference and reliability, the cuff type has become the mainstream form of wearable blood pressure measuring devices and are widely used in the market [72]. This type of wearable device uploads the monitored data to generate a dynamic blood pressure map, which is convenient for patients and doctors. However, during daily continuous monitoring, repeated inflation and deflation of the cuff can cause physical discomfort to the patient, especially at night when the process can cause sleep disturbances [70]. Therefore, a wearable device that can measure dynamic blood pressure accurately and comfortably without a cuff would be attractive prospect. Zheng et al [73] used a wearable sleeveless device developed based on optical technology to monitor blood pressure changes by measuring the pulse arrival time (the pulse transit time from the heart to the peripheral blood vessels). In a mixed methods study, Islam et al [74] demonstrated that wearable blood pressure device measurements compared well against a gold-standard ambulatory device, indicating that this user-friendly method has the potential to enhance blood pressure management in long-term monitoring. However, this type of sleeveless equipment is still in the experimental development stage and has not yet entered the market.

# Diagnosis and Treatment of Diseases

# Overview

A comprehensive understanding of the changes in physiological and pathological indicators during the early stage of disease is critical for timely diagnoses and interventions. Wearable devices are of great significance in the diagnosis and treatment of various diseases by monitoring the changes in vital signs on a real-time basis [42].

# Neurological Disorders

For example, early warning and intervention in the predementia phase of Alzheimer disease are of great significance in delaying the onset and reducing the incidence [75]. Mild cognitive dysfunction is a major feature of predementia in Alzheimer disease, and diagnostic methods at this stage are not yet fully developed [76]. Recent studies have shown that gait is a noninvasive biological indicator of cognitive function [75,77,78]. By wearing a wearable device, the user’s gait parameters can be collected for early detection of Alzheimer disease. In addition, wearable devices also show good application prospects in the early diagnosis of other neurological diseases. For instance, Mannini et al [79] developed a wearable device that analyzes gait classification to improve the accuracy of diagnosis of early neurological diseases.

# Respiratory Diseases

For patients with obstructive sleep apnea hypopnea syndrome, the application of wearable nocturnal breathing monitoring equipment can improve the accuracy of early diagnosis and can be used at home [80]. Surrel et al [81] developed a wearable, accurate, and energy efficient system for monitoring obstructive sleep apnea on a long-term basis.

# Cardiac Conduction System Anomalies

For patients who may be at risk of cardiac arrest, a wearable defibrillator can help monitor arrhythmias. Moreover, emergency defibrillation can be performed to restore normal rhythm when cardiac arrest or ventricular fibrillation is detected [82]. The annual meeting of the American Association for Cancer Research in 2017 also reported that a medical wearable device that delivers alternating currents extends the overall survival of patients with malignant gliomas [83].

# Urinary Diseases

For end-stage renal disease, Gura et al [84] showed that treatment with a wearable artificial kidney was well tolerated and resulted in effective uremic solute clearance and maintenance of electrolyte and fluid homeostasis.

However, wearable devices still have a long way to go in terms of therapeutic applications compared to their health monitoring functions. It should be pointed out that in recent years, with the rise of VR, augmented reality, and mixed reality technology and the breakthrough of remote technology, wearable equipment has also undergone significant developments for application in settings such as medical education, the formulation of preoperative surgery plans, intraoperative navigation, preoperative doctor-patient communication, and remote consultation [16]. In our previous studies [16,85-87], we successfully implemented mixed reality technology to facilitate preoperative communications between doctors and patients, intraoperative guidance, remote surgical consultation, and surgical navigation through HoloLens glasses.

# Rehabilitation

# Overview

In the field of rehabilitation, wearable devices are used mainly in sports rehabilitation [88], cognitive rehabilitation [89], and as rehabilitation aids for people with disabilities [90].

# Sports Rehabilitation

Conditions such as stroke, brain trauma, spinal cord injury, and musculoskeletal injury often lead to the loss or decrease of a patient’s motor ability. The main goal of sports rehabilitation is to restore balance and coordination, to ensure normal joint mobility, and to have sufficient muscle strength and muscular endurance for daily life [91]. Traditional sports rehabilitation is mainly performed in specific medical institutions by professional rehabilitation practitioners who carry out training to expand the range of motion of joints, enhance muscle strength and endurance, and improve balance and coordination function. This mode of rehabilitation training has the advantages of safe reliable methods and real-time guidance from professionals [92]. At the same time, there are some shortcomings in the traditional rehabilitation model that cannot be ignored, such as limitations in the time and place of rehabilitation, as well as the boredom and tedium of the process, resulting in lack of adherence among patients, even those who are not older adults, all of which seriously affect the efficacy of sports rehabilitation [21]. The application of wearable devices, especially in combination with VR, augmented reality, and mixed reality technologies, not only offers the ability to comprehensively monitor and evaluate the rehabilitation activities of patients but also to make the activities more interesting and improve patient adherence [92].

Limb hemiplegia after brain injury is a difficult problem in sports rehabilitation [93]. According to The Chinese Stroke Prevention Report in 2018, stroke has become the leading cause of death in China and the leading cause of disability in Chinese adults [94]. In an aging society, the incidence of stroke is expected to increase in the coming years. Among the various defects caused by stroke, unilateral sensorimotor deficits are very prominent, and $8 0 \%$ of stroke patients have different degrees of gait abnormalities [95]. At present, lower limb rehabilitation for stroke patients is focused mainly on gait training [28]. The wearable device can be used to monitor the patient’s gait parameters and provide feedback to help the doctor assess the patient’s recovery in real time so that the treatment plan can be adjusted accordingly. Hsu et al [96] used a multiplaced wearable sensor to analyze and classify gait characteristics in patients with neurological disorders to guide the selection of rehabilitation exercise regimens. Furthermore, in cases of hemiplegia of a single limb caused by neurological disease, the recovery of arm function lags behind other functions, although the posture and gait may be significantly improved [97]. Maceira-Elvira et al [98] used a wearable stroke rehabilitation trainer to support patients performing a personalized upper limb neuromotor training program at home. The built-in wireless sensor records the patient’s exercise volume, analyzes the data and feeds the data back to the patient and therapist, thus bringing additional improvement to the recovery of the patient’s upper limb functions. Using an optimized wearable glove, a team from the University of Pisa used hand posture reconstruction technology to reconstruct hand movements, allowing real-time recording and feedback on a patient’s hand function recovery [99].

Moreover, in a broad sense, the rehabilitation treatment of spinal cord injury and musculoskeletal injury can be categorized as orthopedic rehabilitation. The use of orthopedic aids is particularly important in the treatment of modern orthopedic rehabilitation. For patients with spinal cord injury, early rehabilitation treatment leads to better the recovery of spinal nerve function mainly through improvements in nerve plasticity [100]. Traditional rehabilitation treatment, which is guided mainly by professional rehabilitators in hospitals, is a costly process requiring a long period of hospitalization. Furthermore, the qualification requirements of the rehabilitation professionals are often high, and one-on-one professional guidance is not always possible. Many researchers [101,102] have designed wearable artificial exoskeletons based on bionics, the principle of which is to transfer the human body load to the artificial exoskeleton and assist in maintaining the standing posture of patients with spinal cord injury. This approach is also designed to allow the patient to walk slowly with a fixed gait maintained by the dynamics and feedback systems of the artificial exoskeleton, thus avoiding joint dysfunction such as joint stiffness and muscle contracture [103]. On the other hand, 3 factors are key to the success of treatment of musculoskeletal system injury: reduction, fixation, and functional exercise [104]. The rehabilitation exercises in the later stage after the injury are the most important. Many orthopedic surgeons in clinical practice often consider only the aesthetics of the operation, neglecting the importance of postoperative limb function rehabilitation. Furthermore, many patients pay insufficient attention to postoperative rehabilitation exercise, with poor adherence, and fear of pain, all of which affect the recovery of the function of the affected limb and greatly reduce the effectiveness of the surgery. The use of wearable devices can encourage patients to perform rehabilitation exercises and allow adjustment of the intensity of rehabilitation training to improve training results based on feedback information [103]. The electronic-assisted instrument system developed by Zhu et al [105] promoted the recovery of knee flexion and extension function in patients after total knee arthroplasty. Lee et al [106] designed an exoskeleton suit that can assist multiple joint movements and measure the direction and angle of movement. Through intuitive recording of the data, which is displayed in a graphical form, the exoskeleton suit provides patients and physicians with information about the effectiveness and extent of the exercise, which is conducive to early rehabilitation and restoration of function.

# Cognitive Rehabilitation

Cognitive dysfunction, which is one of the most common sequelae after brain injury, not only influences the quality of life of patients but also puts tremendous pressure on patients’ families and society [107]. Therefore, improvements in rehabilitation methods are of great significance for cognitive dysfunction. VR glasses have shown great potential in providing treatment options and assessment tools for patients with cognitive impairment [108-110]. VR technology has 3 characteristics, namely immersion, interactivity, and imagination [111]. By providing visual, auditory, and tactile sensory simulation, patients are provided with an immersive experience that aids cognitive rehabilitation in a controlled stimulation environment and facilitates monitoring of related parameters in real time. VR technology offers the potential to develop a personalized treatment plan for patients with different levels of cognitive impairment by providing virtual reproducible images, which are effective in the recovery of memory impairment. To date, many studies have demonstrated the value of VR-based wearable devices in the rehabilitation of cognitive impairment. According to the characteristics of immersion, Faria et al [112] designed VR glasses to perform memory recovery training in patients with cognitive dysfunction, reducing their fear of reality and improving their learning and behavioral abilities. Wåhlin et al [113] used VR training to improve left-sided awareness in chronic stroke patients also increased sporadic interhemispheric functional connectivity within the dorsal attention network.

# Rehabilitation Aids for People With Disabilities

Accessories for people with disabilities is another major direction in the field of wearable devices for rehabilitation. Such accessories include intelligent glasses for the blind, smart hearing aids, and intelligent prosthetics.

Using artificial intelligence technology, smart glasses for the blind [114] not only help individuals with visual impairments interpret information about their surroundings (identified by a pinhole camera, eg, to analyze road condition information in real time) but also aid in making effective decisions. Moreover, smart glasses can help individuals with visual impairment to use a variety of smart home products in a family setting, thus allowing them to improve their quality of life [115].

The hearing aid is essentially an electroacoustic amplifier [116]. The acoustic signal is converted into an electrical signal by a microphone, and after amplification, the electrical signal is restored by the receiver to an acoustic signal and transmitted to the human ear. The emergence of intelligent technology has promoted the development of the hearing aid industry, allowing users to autonomously choose the clearest sound they want to hear in a complex and changing environment, freeing them from the disadvantages of hearing disorders.

For patients with limb defects, the prosthesis can not only fill the shape defect but also restore full or partial residual limb function [117]. Traditional prosthetics are cumbersome, and the invention of wearable smart prostheses is very encouraging for patients with physical disabilities. Intelligent prostheses incorporating robotics have become a hot topic in recent years [118].

# Discussion

# Existing Issues

# Overview

The development of wearable medical equipment has increased the popularity and quality of health care. Moreover, these developments have, to a certain extent, alleviated the shortage of medical resources in low-income countries and promoted the development of medical care worldwide. However, the wearable medical device industry is still in development and currently faces several important limitations that prevent further use of wearable technology in medical practice.

Strategies to ensure the security of the data and improve the public trust are required.

# Lack of Industry Standards and Regulations

In the absence of industry standards and regulations, all companies hope to rely on their core products to form their own standards and regulations, making it difficult to integrate resources. So, the establishment and enforcement of new regulatory standards are required [71,118].

# Technological Barriers

There are many technical bottlenecks in the applications of wearable medical devices [64,124,125]: (1) Data accuracy [9,24,118,122]: On one hand, the sensor specificity of current wearable device is low, which may lead to overdetection of benign nonclinical related signals, resulting in misdiagnosis, unnecessary examinations, and patient anxiety. On the other hand, low sensor sensitivity may lead to omission of pathological clinically-relevant parameters, resulting in missed diagnosis and delay in treatment. (2) Single function: The compatibility of wearable devices is relatively poor, the functions are mainly concentrated on the level of health monitoring, with slow progress in clinical treatment, and few wearable medical devices have effectively integrated multiple functions [27,124]. (3) Poor battery life: Designing low-power consuming and high-energy storage wearable devices has always been an exciting but challenging issue [10,120]. (4) Equipment safety: Safety and security are primary considerations for medical equipment, closely related to reliability at all system levels [12,13]. Because false alarms would reduce user alertness and prevent user adherence from the feedback provided, efficient mechanisms are needed to detect and diagnose deviations occurring in captured data [126]. (5) Other issues such as cost, low data collection and processing efficiency, unstable human-computer interaction interfaces, and incomplete construction of big data health clouds need to be further improved [9,13,122].

# Barriers to User-Friendly Solutions

For the health care system, the main challenge is to enable the use of these technologies by changing the model of care and by sharing information [119]. Data collection, transfer, preservation, and sharing require not only the development of technical solutions but also the development of legal infrastructure, which will enable different organizations to share data and responsibilities for patient [120]. On one hand, patient autonomy in using wearable health devices needs to be kept to help patients to become active participants in their own care [119]. On the other hand, the duty of clinicians and the responsibilities for misdiagnosis and missed diagnosis due to the use of unreliable or delayed data and false alarms during the use of wearable devices should also be legally regulated [121].

# Security and Privacy Concerns

Through sensor technology, wearable health devices can collect all kinds of user information, such as health information, geographical location, and living habits [34]. The various formats, large scale, and numerous mobile links of these data may increase the risk of leakage and tampering [8,35,122,123].

# Limitations

There were some limitations in our review. Although some databases are included, our search terms may cause the omission of relevant papers. Due to the exploratory nature of this review, it included a wide range of research designs, and the review will ultimately be limited by the design of the included studies. Although the second and third reviewers used strategies to limit bias through consultation, they also acknowledge the possibility of subjectivity in analyzing the survey results. Additionally, this paper is not intended to be a systematic review, and it is possible to conduct a broader review and find papers suggesting other applications of wearable devices.

# Conclusion and Future Directions

Despite many limitations in their application, wearable devices have achieved remarkable success and have brought huge benefits to the aging global population. The authors believe that the following aspects are crucial for future development of the wearable device industry:

1. Strengthening oversight of the wearable device industry, formulating specific security rules to protect the privacy and security of personal data, and clarifying the relevant medical responsibilities and rights between doctors and patients.

2. Establishment and enforcement of industry standards by taking health care as the main body of information to establish a unified data classification, evaluation system, and industry standards for wearable device to realize the mutual recognition of medical data.

3. Technological advancement in wearable health devices to develop low-consumption and high-integration sensor technology; low-power high-performance battery technology; high processing efficiency medical chip technology; and human-computer interaction technology to improve information accuracy, information processing speed, extend battery life, and user experience.

4. Combining big data, cloud computing, and IoT—the internet of things—to build a healthy database to develop a complete medical ecosystem. Using this resource, we can fully develop, analyze, and employ medical and health big data to expand the use of wearable devices in other fields, such as telemedicine, preventive medicine, and epidemiology [12].

By combining smart wearable medical devices with pension services, a smart retirement community can be built to provide high-quality, high-efficiency medical care services. How medical services are sought has also begun to transform from passive medical treatment of disease to community medical models led by prevention, health care, and prediagnosis.

In summary, with the development of science and technology and the popularization of personalized health concepts, wearable devices will inevitably play a greater role in the field of health care and become better integrated into our daily lives. However, more research is needed to explore further applications of wearable devices in the medical field.

# Acknowledgments

This work was supported by Foundation for the Science and Technology Commission of Hubei (grant no. 2018AAA067) and the National Natural Science Foundation of China (no. 81974355).

# Conflicts of Interest

None declared.

# References

1. Amft O, Lukowicz P. From backpacks to smartphones: past, present, and future of wearable computers. IEEE Pervasive Comput 2009 Jul;8(3):8-13 [FREE Full text] [doi: 10.1109/MPRV.2009.44]   
2. Khan Y, Ostfeld AE, Lochner CM, Pierre A, Arias AC. Monitoring of vital signs with flexible and wearable medical devices. Adv Mater 2016 Jun;28(22):4373-4395 [FREE Full text] [doi: 10.1002/adma.201504366] [Medline: 26867696]   
3. Guze PA. Using technology to meet the challenges of medical education. Trans Am Clin Climatol Assoc 2015;126:260-270 [FREE Full text] [Medline: 26330687]   
4. Jackson MM, Valentin G, Freil L, Burkeen L, Zeagler C, Gilliland S, et al. FIDO—Facilitating interactions for dogs with occupations: wearable communication interfaces for working dogs. Pers Ubiquit Comput 2015 Oct 11;19(1):155-173 [FREE Full text] [doi: 10.1007/s00779-014-0817-9]   
5. Siddall AG, Powell SD, Needham-Beck SC, Edwards VC, Thompson JE, Kefyalew SS, et al. Validity of energy expenditure estimation methods during 10 days of military training. Scand J Med Sci Sports 2019 Sep;29(9):1313-1321 [FREE Full text] [doi: 10.1111/sms.13488] [Medline: 31136027]   
6. Park Y, Lee S, Park J. Recent progress in wireless sensors for wearable electronics. Sensors (Basel) 2019 Oct 09;19(20) [FREE Full text] [doi: 10.3390/s19204353] [Medline: 31600870]   
7. Haghi M, Thurow K, Stoll R. Wearable devices in medical internet of things: scientific research and commercially available devices. Healthc Inform Res 2017 Jan;23(1):4-15 [FREE Full text] [doi: 10.4258/hir.2017.23.1.4] [Medline: 28261526]   
8. Guk K, Han G, Lim J, Jeong K, Kang T, Lim E, et al. Evolution of wearable devices with real-time disease monitoring for personalized health care. Nanomaterials (Basel) 2019 May 29;9(6) [FREE Full text] [doi: 10.3390/nano9060813] [Medline: 31146479]   
9. Qian R, Long Y. Wearable chemosensors: a review of recent progress. Chemistry Open 2018 Feb;7(2):118-130 [FREE Full text] [doi: 10.1002/open.201700159] [Medline: 29435397]   
10. Lin B. Wearable smart devices for p4 medicine in heart disease: ready for medical cyber-physical systems? OMICS 2019 May;23(5):291-292 [FREE Full text] [doi: 10.1089/omi.2019.0059] [Medline: 31050597]   
11. Jeong IC, Bychkov D, Searson PC. Wearable devices for precision medicine and health state monitoring. IEEE Trans Biomed Eng 2019 May;66(5):1242-1258 [FREE Full text] [doi: 10.1109/tbme.2018.2871638]   
12. Loncar-Turukalo T, Zdravevski E, Machado da Silva J, Chouvarda I, Trajkovik V. Literature on wearable technology for connected health: scoping review of research trends, advances, and barriers. J Med Internet Res 2019 Sep 05;21(9):e14017 [FREE Full text] [doi: 10.2196/14017] [Medline: 31489843]   
13. Sim I. Mobile devices and health. N Engl J Med 2019 Sep 05;381(10):956-968 [FREE Full text] [doi: 10.1056/NEJMra1806949] [Medline: 31483966]   
14. Grant M, Booth A. A typology of reviews: an analysis of 14 review types and associated methodologies. Health Info Libr J 2009 Jun;26(2):91-108 [FREE Full text] [doi: 10.1111/j.1471-1842.2009.00848.x] [Medline: 19490148]   
15. Koydemir HC, Ozcan A. Wearable and implantable sensors for biomedical applications. Annu Rev Anal Chem (Palo Alto Calif) 2018 Jun 12;11(1):127-146. [doi: 10.1146/annurev-anchem-061417-125956] [Medline: 29490190]   
16. Hu H, Feng X, Shao Z, Xie M, Xu S, Wu X, et al. Application and prospect of mixed reality technology in medical field. Curr Med Sci 2019 Feb;39(1):1-6. [doi: 10.1007/s11596-019-1992-8] [Medline: 30868484]   
17. Wang Q, Markopoulos P, Yu B, Chen W, Timmermans A. Interactive wearable systems for upper body rehabilitation: a systematic review. J Neuroeng Rehabil 2017 Mar 11;14(1):20 [FREE Full text] [doi: 10.1186/s12984-017-0229-y] [Medline: 28284228]   
18. Walmsley CP, Williams SA, Grisbrook T, Elliott C, Imms C, Campbell A. Measurement of upper limb range of motion using wearable sensors: a systematic review. Sports Med Open 2018 Nov 29;4(1):53 [FREE Full text] [doi: 10.1186/s40798-018-0167-7] [Medline: 30499058]   
19. Liang J, Xian D, Liu X, Fu J, Zhang X, Tang B, et al. Usability study of mainstream wearable fitness devices: feature analysis and system usability scale evaluation. JMIR Mhealth Uhealth 2018 Nov 08;6(11):e11066 [FREE Full text] [doi: 10.2196/11066] [Medline: 30409767]   
20. Powell L, Parker J, Martyn St-James M, Mawson S. The effectiveness of lower-limb wearable technology for improving activity and participation in adult stroke survivors: a systematic review. J Med Internet Res 2016 Oct 07;18(10):e259 [FREE Full text] [doi: 10.2196/jmir.5891] [Medline: 27717920]   
21. Xu J, Bao T, Lee UH, Kinnaird C, Carender W, Huang Y, et al. Configurable, wearable sensing and vibrotactile feedback system for real-time postural balance and gait training: proof-of-concept. J Neuroeng Rehabil 2017 Oct 11;14(1):102 [FREE Full text] [doi: 10.1186/s12984-017-0313-3] [Medline: 29020959]   
22. Argent R, Slevin P, Bevilacqua A, Neligan M, Daly A, Caulfield B. Clinician perceptions of a prototype wearable exercise biofeedback system for orthopaedic rehabilitation: a qualitative exploration. BMJ Open 2018 Oct 25;8(10):e026326. [doi: 10.1136/bmjopen-2018-026326] [Medline: 30366919]   
23. Zhang H, Liu F. Updated Technology and Application of Intelligent Electric Wears. China Textile Leader 2011;12:108-110 [FREE Full text] [doi: 10.3969/j.issn.1003-3025.2011.12.029]   
24. Burmester GR. Rheumatology 4.0: big data, wearables and diagnosis by computer. Ann Rheum Dis 2018 Jul;77(7):963-965. [doi: 10.1136/annrheumdis-2017-212888] [Medline: 29802224]   
25. Jo A, Coronel BD, Coakes CE, Mainous AG. Is there a benefit to patients using wearable devices such as Fitbit or health apps on mobiles?: a systematic review. Am J Med 2019 Dec;132(12):1394-1400.e1 [FREE Full text] [doi: 10.1016/j.amjmed.2019.06.018] [Medline: 31302077]   
26. Maddison R, Cartledge S, Rogerson M, Goedhart NS, Ragbir Singh T, Neil C, et al. Usefulness of wearable cameras as a tool to enhance chronic disease self-management: scoping review. JMIR Mhealth Uhealth 2019 Jan 03;7(1):e10371 [FREE Full text] [doi: 10.2196/10371] [Medline: 30609985]   
27. Ray PP, Dash D, De D. A systematic review of wearable systems for cancer detection: current state and challenges. J Med Syst 2017 Oct 02;41(11):180 [FREE Full text] [doi: 10.1007/s10916-017-0828-y] [Medline: 28971278]   
28. Jayaraman C, Mummidisetty CK, Mannix-Slobig A, McGee Koch L, Jayaraman A. Variables influencing wearable sensor outcome estimates in individuals with stroke and incomplete spinal cord injury: a pilot investigation validating two research grade sensors. J Neuroeng Rehabil 2018 Mar 13;15(1):19 [FREE Full text] [doi: 10.1186/s12984-018-0358-y] [Medline: 29534737]   
29. Takei K, Honda W, Harada S, Arie T, Akita S. Toward flexible and wearable human-interactive health-monitoring devices. Adv Healthc Mater 2015 Mar 11;4(4):487-500 [FREE Full text] [doi: 10.1002/adhm.201400546] [Medline: 25425072]   
30. Baig MM, Afifi S, GholamHosseini H, Mirza F. A systematic review of wearable sensors and IoT-based monitoring applications for older adults - a focus on ageing population and independent living. J Med Syst 2019 Jun 15;43(8):233 [FREE Full text] [doi: 10.1007/s10916-019-1365-7] [Medline: 31203472]   
31. Godfrey A. Wearables for independent living in older adults: Gait and falls. Maturitas 2017 Jun;100:16-26 [FREE Full text] [doi: 10.1016/j.maturitas.2017.03.317] [Medline: 28539173]   
32. Jung S, Hong S, Kim J, Lee S, Hyeon T, Lee M, et al. Wearable fall detector using integrated sensors and energy devices. Sci Rep 2015 Nov 24;5:17081 [FREE Full text] [doi: 10.1038/srep17081] [Medline: 26597423]   
33. Mackintosh KA, Chappel SE, Salmon J, Timperio A, Ball K, Brown H, et al. Parental perspectives of a wearable activity tracker for children younger than 13 years: acceptability and usability study. JMIR Mhealth Uhealth 2019 Nov 04;7(11):e13858 [FREE Full text] [doi: 10.2196/13858] [Medline: 31682585]   
34. Wen D, Zhang X, Lei J. Consumers' perceived attitudes to wearable devices in health monitoring in China: A survey study. Comput Methods Programs Biomed 2017 Mar;140:131-137 [FREE Full text] [doi: 10.1016/j.cmpb.2016.12.009] [Medline: 28254069]   
35. Sequeira L, Perrotta S, LaGrassa J, Merikangas K, Kreindler D, Kundur D, et al. Mobile and wearable technology for monitoring depressive symptoms in children and adolescents: A scoping review. J Affect Disord 2020 Mar 15;265:314-324 [FREE Full text] [doi: 10.1016/j.jad.2019.11.156] [Medline: 32090755]   
36. Prioreschi A, Nappey T, Westgate K, Olivier P, Brage S, Micklesfield LK. Development and feasibility of a wearable infant wrist band for the objective measurement of physical activity using accelerometery. Pilot Feasibility Stud 2018;4:60 [FREE Full text] [doi: 10.1186/s40814-018-0256-x] [Medline: 29507750]   
37. Bachiri M, Idri A, Fernández-Alemán JL, Toval A. Mobile personal health records for pregnancy monitoring functionalities: Analysis and potential. Comput Methods Programs Biomed 2016 Oct;134:121-135 [FREE Full text] [doi: 10.1016/j.cmpb.2016.06.008] [Medline: 27480737]   
38. Godinho C, Domingos J, Cunha G, Santos AT, Fernandes RM, Abreu D, et al. A systematic review of the characteristics and validity of monitoring technologies to assess Parkinson's disease. J Neuroeng Rehabil 2016 Mar 12;13:24 [FREE Full text] [doi: 10.1186/s12984-016-0136-7] [Medline: 26969628]   
39. van Andel J, Ungureanu C, Aarts R, Leijten F, Arends J. Using photoplethysmography in heart rate monitoring of patients with epilepsy. Epilepsy Behav 2015 Apr;45:142-145 [FREE Full text] [doi: 10.1016/j.yebeh.2015.02.018] [Medline: 25812938]   
40. Ryvlin P, Ciumas C, Wisniewski I, Beniczky S. Wearable devices for sudden unexpected death in epilepsy prevention. Epilepsia 2018 Jun;59 Suppl 1:61-66 [FREE Full text] [doi: 10.1111/epi.14054] [Medline: 29873831]   
41. van der Heide I, Poureslami I, Mitic W, Shum J, Rootman I, FitzGerald JM. Health literacy in chronic disease management: a matter of interaction. J Clin Epidemiol 2018 Oct;102:134-138 [FREE Full text] [doi: 10.1016/j.jclinepi.2018.05.010] [Medline: 29793001]   
42. Sun J, Guo Y, Wang X, Zeng Q. mHealth for aging China: opportunities and challenges. Aging Dis 2016 Jan;7(1):53-67 [FREE Full text] [doi: 10.14336/AD.2015.1011] [Medline: 26816664]   
43. Singh S, Kullo IJ, Pardi DS, Loftus EV. Epidemiology, risk factors and management of cardiovascular diseases in IBD. Nat Rev Gastroenterol Hepatol 2015 Jan;12(1):26-35 [FREE Full text] [doi: 10.1038/nrgastro.2014.202] [Medline: 25446727]   
44. Dolabchian ZL. [Electrophysiological classification of myocardial infarct]. Kardiologiia 1975 Jan;15(1):113-115 [FREE Full text] [Medline: 1117614]   
45. Fumagalli S, Chen J, Dobreanu D, Madrid AH, Tilz R, Dagres N. The role of the Arrhythmia Team, an integrated, multidisciplinary approach to treatment of patients with cardiac arrhythmias: results of the European Heart Rhythm Association survey. Europace 2016 May 12;18(4):623-627. [doi: 10.1093/europace/euw090]   
46. Steinberg C, Philippon F, Sanchez M, Fortier-Poisson P, O'Hara G, Molin F, et al. A novel wearable device for continuous ambulatory ECG recording: proof of concept and assessment of signal quality. Biosensors (Basel) 2019 Jan 21;9(1) [FREE Full text] [doi: 10.3390/bios9010017] [Medline: 30669678]   
47. Tsukada YT, Tokita M, Murata H, Hirasawa Y, Yodogawa K, Iwasaki Y, et al. Validation of wearable textile electrodes for ECG monitoring. Heart Vessels 2019 Jul;34(7):1203-1211 [FREE Full text] [doi: 10.1007/s00380-019-01347-8] [Medline: 30680493]   
48. Ip JE. Wearable devices for cardiac rhythm diagnosis and management. JAMA 2019 Jan 29;321(4):337-338 [FREE Full text] [doi: 10.1001/jama.2018.20437] [Medline: 30633301]   
49. Kaspar G, Sanam K, Gholkar G, Bianco NR, Szymkiewicz S, Shah D. Long-term use of the wearable cardioverter defibrillator in patients with explanted ICD. Int J Cardiol 2018 Dec 01;272:179-184 [FREE Full text] [doi: 10.1016/j.ijcard.2018.08.017] [Medline: 30121177]   
50. Homma T, Kawahara T, Mikuni H, Uno T, Sato H, Fujiwara A, et al. Beneficial effect of early intervention with garenoxacin for bacterial infection-induced acute exacerbation of bronchial asthma and chronic obstructive pulmonary disease. Int Arch Allergy Immunol 2019;178(4):355-362 [FREE Full text] [doi: 10.1159/000495761] [Medline: 30759444]   
51. Rubio N, Parker RA, Drost EM, Pinnock H, Weir CJ, Hanley J, et al. Home monitoring of breathing rate in people with chronic obstructive pulmonary disease: observational study of feasibility, acceptability, and change after exacerbation. Int J Chron Obstruct Pulmon Dis 2017;12:1221-1231 [FREE Full text] [doi: 10.2147/COPD.S120706] [Medline: 28458534]   
52. Pericleous P, van Staa TP. The use of wearable technology to monitor physical activity in patients with COPD: a literature review. Int J Chron Obstruct Pulmon Dis 2019;14:1317-1322 [FREE Full text] [doi: 10.2147/COPD.S193037] [Medline: 31354259]   
53. Khan S, Ali S, Bermak A. Recent developments in printing flexible and wearable sensing electronics for health care applications. Sensors (Basel) 2019 Mar 11;19(5):1230 [FREE Full text] [doi: 10.3390/s19051230] [Medline: 30862062]   
54. Wu R, Liaqat D, de Lara E, Son T, Rudzicz F, Alshaer H, et al. Feasibility of using a smartwatch to intensively monitor patients with chronic obstructive pulmonary disease: prospective cohort study. JMIR Mhealth Uhealth 2018 Jun 14;6(6):e10046 [FREE Full text] [doi: 10.2196/10046] [Medline: 29903700]   
55. Colantonio S, Govoni L, Dellacà RL, Martinelli M, Salvetti O, Vitacca M. Decision making concepts for the remote, personalized evaluation of COPD patients' health status. Methods Inf Med 2015;54(3):240-247 [FREE Full text] [doi: 10.3414/ME13-02-0038] [Medline: 25502493]   
56. Li B, Dong Q, Downen RS, Tran N, Jackson JH, Pillai D, et al. A wearable IoT aldehyde sensor for pediatric asthma research and managemen. Sens Actuators B Chem 2019 May 15;287:584-594 [FREE Full text] [doi: 10.1016/j.snb.2019.02.077] [Medline: 31938011]   
57. Katwa U, Rivera E. Asthma management in the era of smart-medicine: devices, gadgets, apps and telemedicine. Indian J Pediatr 2018 Sep;85(9):757-762 [FREE Full text] [doi: 10.1007/s12098-018-2611-6] [Medline: 29524089]   
58. Flannick J, Johansson S, Njølstad PR. Common and rare forms of diabetes mellitus: towards a continuum of diabetes subtypes. Nat Rev Endocrinol 2016 Jul;12(7):394-406 [FREE Full text] [doi: 10.1038/nrendo.2016.50] [Medline: 27080136]   
59. American Diabetes Association. Diagnosis and classification of diabetes mellitus. Diabetes Care 2013 Jan;36 Suppl 1:S67-S74 [FREE Full text] [doi: 10.2337/dc13-S067] [Medline: 23264425]   
60. Tentolouris A, Eleftheriadou I, Tzeravini E, Athanasakis K, Anastasiou IA, Kyriopoulos J, et al. Management of diabetes mellitus and patients' attitude towards the disease: Data from a nationwide study in Greece. Diabetes Metab Syndr 2019;13(2):1159-1164 [FREE Full text] [doi: 10.1016/j.dsx.2019.01.030] [Medline: 31336459]   
61. Vishwanathan V. Current and future perspective in the management of diabetes. J Indian Med Assoc 2002 Mar;100(3):181-183 [FREE Full text] [Medline: 12408280]   
62. Wan EYF, Fung CSC, Jiao FF, Yu EYT, Chin WY, Fong DYT, et al. Five-year effectiveness of the multidisciplinary risk assessment and management programme-diabetes mellitus (RAMP-DM) on diabetes-related complications and health service uses-a population-based and propensity-matched cohort study. Diabetes Care 2018 Jan;41(1):49-59 [FREE Full text] [doi: 10.2337/dc17-0426] [Medline: 29138274]   
63. Gao W, Brooks GA, Klonoff DC. Wearable physiological systems and technologies for metabolic monitoring. J Appl Physiol (1985) 2018 Mar 01;124(3):548-556. [doi: 10.1152/japplphysiol.00407.2017] [Medline: 28970200]   
64. Sabu C, Henna T, Raphey V, Nivitha K, Pramod K. Advanced biosensors for glucose and insulin. Biosens Bioelectron 2019 Sep 15;141:111201. [doi: 10.1016/j.bios.2019.03.034] [Medline: 31302426]   
65. Pandey R, Paidi SK, Valdez TA, Zhang C, Spegazzini N, Dasari RR, et al. Noninvasive monitoring of blood glucose with raman spectroscopy. Acc Chem Res 2017 Feb 21;50(2):264-272 [FREE Full text] [doi: 10.1021/acs.accounts.6b00472] [Medline: 28071894]   
66. Pillalamarri SS, Huyett LM, Abdel-Malek A. Novel bluetooth-enabled tubeless insulin pump: a user experience design approach for a connected digital diabetes management platform. J Diabetes Sci Technol 2018 Nov;12(6):1132-1142. [doi: 10.1177/1932296818804802] [Medline: 30304951]   
67. Elliott WJ. Systemic hypertension. Curr Probl Cardiol 2007 Apr;32(4):201-259 [FREE Full text] [doi: 10.1016/j.cpcardiol.2007.01.002] [Medline: 17398315]   
68. Oparil S, Acelajado MC, Bakris GL, Berlowitz DR, Cífková R, Dominiczak AF, et al. Hypertension. Nat Rev Dis Primers 2018 Mar 22;4:18014 [FREE Full text] [doi: 10.1038/nrdp.2018.14] [Medline: 29565029]   
69. Holt TR, Withington DE, Mitchell E. Which pressure to believe? A comparison of direct arterial with indirect blood pressure measurement techniques in the pediatric intensive care unit. Pediatric Critical Care Medicine 2011;12(6):e391-e394 [FREE Full text] [doi: 10.1097/pcc.0b013e3182230f43] [Medline: 21666539]   
70. Cheng H, Sung S, Chen C, Yu W, Yang S, Guo C, et al. Guiding hypertension management using different blood pressure monitoring strategies (GYMNs study): comparison of three different blood pressure measurement methods: study protocol for a randomized controlled trial. Trials 2019 May 10;20(1):265 [FREE Full text] [doi: 10.1186/s13063-019-3366-8] [Medline: 31077229]   
71. Zhou W, Jia T, Chen X. The status and prospect of wearable medical health monitoring. China Medical Devices 2017;32(06):1-5. [doi: 10.3969/j.issn.1674-1633.2017.06.001]   
72. Qi L, Wen Y. Research and application progress of wearable blood pressure measurement device. China Medical Devices 2016;31(12):77-79. [doi: 10.3969/j.issn.1674-1633.2016.12.019]   
73. Zheng Y, Poon CCY, Yan BP, Lau JYW. Pulse arrival time based cuff-less and 24-h wearable blood pressure monitoring and its diagnostic value in hypertension. J Med Syst 2016 Sep;40(9):195 [FREE Full text] [doi: 10.1007/s10916-016-0558-6] [Medline: 27447469]   
74. Islam SMS, Cartledge S, Karmakar C, Rawstorn JC, Fraser SF, Chow C, et al. Validation and acceptability of a cuffless wrist-worn wearable blood pressure monitoring device among users and health care professionals: mixed methods study. JMIR Mhealth Uhealth 2019 Sep 14;7(10):e14706 [FREE Full text] [doi: 10.2196/14706] [Medline: 31628788]   
75. Mc Ardle R, Del Din S, Galna B, Thomas A, Rochester L. Differentiating dementia disease subtypes with gait analysis: feasibility of wearable sensors? Gait Posture 2020 Feb;76:372-376 [FREE Full text] [doi: 10.1016/j.gaitpost.2019.12.028] [Medline: 31901765]   
76. Lane CA, Hardy J, Schott JM. Alzheimer's disease. Eur J Neurol 2018 Jan;25(1):59-70 [FREE Full text] [doi: 10.1111/ene.13439] [Medline: 28872215]   
77. Ricci M, Di Lazzaro G, Pisani A, Mercuri NB, Giannini F, Saggio G. Assessment of motor impairments in early untreated Parkinson's disease patients: the wearable electronics impact. IEEE J Biomed Health Inform 2020 Jan;24(1):120-130 [FREE Full text] [doi: 10.1109/JBHI.2019.2903627] [Medline: 30843855]   
78. Monje MH, Foffani G, Obeso J, Sánchez-Ferro Á. new sensor and wearable technologies to aid in the diagnosis and treatment monitoring of Parkinson's disease. Annu Rev Biomed Eng 2019 Jun 04;21:111-143 [FREE Full text] [doi: 10.1146/annurev-bioeng-062117-121036] [Medline: 31167102]   
79. Mannini A, Trojaniello D, Cereatti A, Sabatini A. A machine learning framework for gait classification using inertial sensors: application to older adults, post-stroke and huntington's disease patients. Sensors (Basel) 2016 Jan 21;16(1) [FREE Full text] [doi: 10.3390/s16010134] [Medline: 26805847]   
80. Crupi R, Faetti T, Paradiso R. Preliminary evaluation of wearable wellness system for obstructive sleep apnea detection. Annu Int Conf IEEE Eng Med Biol Soc 2015;2015:4142-4145 [FREE Full text] [doi: 10.1109/EMBC.2015.7319306] [Medline: 26737206]   
81. Surrel G, Aminifar A, Rincon F, Murali S, Atienza D. Online obstructive sleep apnea detection on medical wearable sensors. IEEE Trans Biomed Circuits Syst 2018 Aug;12(4):762-773 [FREE Full text] [doi: 10.1109/TBCAS.2018.2824659] [Medline: 29993894]   
82. Odeneg T, Ebner C, Mörtl D, Keller H, Dirninger A, Stix G, et al. Indications for and outcome in patients with the wearable cardioverter-defibrillator in a nurse-based training programme: results of the Austrian WCD Registry. Eur J Cardiovasc Nurs 2019 Jan;18(1):75-83 [FREE Full text] [doi: 10.1177/1474515118790365] [Medline: 30064269]   
83. Davies H. Wearable medical device improves survival for glioblastoma patients. Cancer 2017 Sep 15;123(18):3433 [FREE Full text] [doi: 10.1002/cncr.30963] [Medline: 28880388]   
84. Gura V, Rivara M, Bieber S, Munshi R, Smith N, Linke L, et al. A wearable artificial kidney for patients with end-stage renal disease. JCI Insight 2016 Jun 02;1(8):74-89 [FREE Full text] [doi: 10.1172/jci.insight.86397] [Medline: 27398407]   
85. Wu X, Liu R, Xu S, Yang C, Yang S, Shao Z, et al. Feasibility of mixed reality-based intraoperative three-dimensional image-guided navigation for atlanto-axial pedicle screw placement. Proc Inst Mech Eng H 2019 Dec;233(12):1310-1317 [FREE Full text] [doi: 10.1177/0954411919881255] [Medline: 31617820]   
86. Wu X, Liu R, Yu J, Xu S, Yang C, Yang S, et al. Mixed reality technology launches in orthopedic surgery for comprehensive preoperative management of complicated cervical fractures. Surg Innov 2018 Aug;25(4):421-422 [FREE Full text] [doi: 10.1177/1553350618761758] [Medline: 30012077]   
87. Wu X, Liu R, Yu J, Xu S, Yang C, Shao Z, et al. Mixed reality technology-assisted orthopedics surgery navigation. Surg Innov 2018 Jun 27;25(3):304-305 [FREE Full text] [doi: 10.1177/1553350618771413] [Medline: 29701134]   
88. Popp WL, Schneider S, Bär J, Bösch P, Spengler CM, Gassert R, et al. Wearable sensors in ambulatory individuals with a spinal cord injury: from energy expenditure estimation to activity recommendations. Front Neurol 2019;10:1092 [FREE Full text] [doi: 10.3389/fneur.2019.01092] [Medline: 31736845]   
89. Faria AL, Andrade A, Soares L, I Badia SB. Benefits of virtual reality based cognitive rehabilitation through simulated activities of daily living: a randomized controlled trial with stroke patients. J Neuroeng Rehabil 2016 Nov 02;13(1):96 [FREE Full text] [doi: 10.1186/s12984-016-0204-z] [Medline: 27806718]   
90. Williamson B, Aplin T, de Jonge D, Goyne M. Tracking down a solution: exploring the acceptability and value of wearable GPS devices for older persons, individuals with a disability and their support persons. Disabil Rehabil Assist Technol 2017 Nov 18;12(8):822-831 [FREE Full text] [doi: 10.1080/17483107.2016.1272140] [Medline: 28100086]   
91. Shi B, Chen X, Yue Z, Yin S, Weng Q, Zhang X, et al. Wearable ankle robots in poststroke rehabilitation of gait: a systematic review. Front Neurorobot 2019;13:63 [FREE Full text] [doi: 10.3389/fnbot.2019.00063] [Medline: 31456681]   
92. van Genderen ME, Vlake J. [Virtual healthcare; use of virtual, augmented and mixed reality]. Ned Tijdschr Geneeskd 2018 Nov 26;162 [FREE Full text] [Medline: 30500123]   
93. Likitlersuang J, Sumitro ER, Theventhiran P, Kalsi-Ryan S, Zariffa J. Views of individuals with spinal cord injury on the use of wearable cameras to monitor upper limb function in the home and community. J Spinal Cord Med 2017 Nov 24;40(6):706-714 [FREE Full text] [doi: 10.1080/10790268.2017.1349856] [Medline: 28738759]   
94. Wang L, Liu J, Yang Y. The prevention and treatment of stroke still face huge challenges??brief report on stroke prevention and treatment in China, 2018. Chinese Circulation Journal 2019;34(02):105. [doi: 10.3969/j.issn.1000-3614.2019.02.001]   
95. Parker VM, Wade DT, Langton Hewer R. Loss of arm function after stroke: measurement, frequency, and recovery. Int Rehabil Med 1986;8(2):69-73 [FREE Full text] [doi: 10.3109/03790798609166178] [Medline: 3804600]   
96. Hsu W, Sugiarto T, Lin Y, Yang F, Lin Z, Sun C, et al. Multiple-wearable-sensor-based gait classification and analysis in patients with neurological disorders. Sensors (Basel) 2018 Oct 11;18(10):3397 [FREE Full text] [doi: 10.3390/s18103397] [Medline: 30314269]   
97. Richard D W, Gerd L, Privender S, Annick T, Jurgen te V, Stefan W. Home stroke rehabilitation for the upper limbs. 2007 Aug 22 Presented at: 29th International Conference of the IEEE Engineering in Medicine and Biology Society; 2007; Lyon, France p. 4015-4018 URL: https://ieeexplore.ieee.org/document/4353214/citations#citations [doi: 10.1109/iembs.2007.4353214]   
98. Maceira-Elvira P, Popa T, Schmid A, Hummel FC. Wearable technology in stroke rehabilitation: towards improved diagnosis and treatment of upper-limb motor impairment. J Neuroeng Rehabil 2019 Nov 19;16(1):142 [FREE Full text] [doi: 10.1186/s12984-019-0612-y] [Medline: 31744553]   
99. Ciotti S, Battaglia E, Carbonaro N, Bicchi A, Tognetti A, Bianchi M. A synergy-based optimally designed sensing glove for functional grasp recognition. Sensors (Basel) 2016 Jun 02;16(6):811 [FREE Full text] [doi: 10.3390/s16060811] [Medline: 27271621]   
100. Dimyan MA, Cohen LG. Neuroplasticity in the context of motor rehabilitation after stroke. Nat Rev Neurol 2011 Feb;7(2):76-85 [FREE Full text] [doi: 10.1038/nrneurol.2010.200] [Medline: 21243015]   
101. Young AJ, Ferris DP. State of the art and future directions for lower limb robotic exoskeletons. IEEE Trans Neural Syst Rehabil Eng 2017 Feb;25(2):171-182 [FREE Full text] [doi: 10.1109/TNSRE.2016.2521160] [Medline: 26829794]   
102. Lu Z, Chen X, Zhang X, Tong K, Zhou P. Real-time control of an exoskeleton hand robot with myoelectric pattern recognition. Int J Neural Syst 2017 Aug;27(5):1750009 [FREE Full text] [doi: 10.1142/S0129065717500095] [Medline: 27873553]   
103. Fan H, Cao X, Yang X. Application and research of wearable devices in orthopedics. Chinese Journal of Bone and Joint Surgery 2018 Feb;11(2):154-160. [doi: 10.3969/j.issn.2095-9958.2018.02.016]   
104. Mandell JC, Khurana B, Smith SE. Stress fractures of the foot and ankle, part 1: biomechanics of bone and principles of imaging and treatment. Skeletal Radiol 2017 Aug;46(8):1021-1029 [FREE Full text] [doi: 10.1007/s00256-017-2640-7] [Medline: 28374052]   
105. Zhu Y, Nakamura M, Horiuchi T, Kohno H, Takahashi R, Terada H, et al. New wearable walking-type continuous passive motion device for postsurgery walking rehabilitation. Proc Inst Mech Eng H 2013 Jul;227(7):733-745 [FREE Full text] [doi: 10.1177/0954411913481557] [Medline: 23636753]   
106. Lee S, Kim J, Baker L, Long A, Karavas N, Menard N, et al. Autonomous multi-joint soft exosuit with augmentation-power-based control parameter tuning reduces energy cost of loaded walking. J Neuroeng Rehabil 2018 Jul 13;15(1):66 [FREE Full text] [doi: 10.1186/s12984-018-0410-y] [Medline: 30001726]   
107. Eshel I, Bowles AO, Ray MR. Rehabilitation of cognitive dysfunction following traumatic brain injury. Phys Med Rehabil Clin N Am 2019 Feb;30(1):189-206. [doi: 10.1016/j.pmr.2018.08.005] [Medline: 30470421]   
108. Hwang J, Lee S. The effect of virtual reality program on the cognitive function and balance of the people with mild cognitive impairment. J Phys Ther Sci 2017 Aug;29(8):1283-1286 [FREE Full text] [doi: 10.1589/jpts.29.1283] [Medline: 28878448]   
109. Chua SIL, Tan NC, Wong WT, Allen JC, Quah JHM, Malhotra R, et al. Virtual reality for screening of cognitive function in older persons: comparative study. J Med Internet Res 2019 Aug 01;21(8):e14821 [FREE Full text] [doi: 10.2196/14821] [Medline: 31373274]   
110. Rogers JM, Duckworth J, Middleton S, Steenbergen B, Wilson PH. Elements virtual rehabilitation improves motor, cognitive, and functional outcomes in adult stroke: evidence from a randomized controlled pilot study. J Neuroeng Rehabil 2019 May 15;16(1):56 [FREE Full text] [doi: 10.1186/s12984-019-0531-y] [Medline: 31092252]   
111. Chirico A, Lucidi F, De Laurentiis M, Milanese C, Napoli A, Giordano A. Virtual reality in health system: beyond entertainment. a mini-review on the efficacy of VR during cancer treatment. J Cell Physiol 2016 Feb;231(2):275-287 [FREE Full text] [doi: 10.1002/jcp.25117] [Medline: 26238976]   
112. Faria AL, Andrade A, Soares L, I Badia SB. Benefits of virtual reality based cognitive rehabilitation through simulated activities of daily living: a randomized controlled trial with stroke patients. J Neuroeng Rehabil 2016 Nov 02;13(1):96 [FREE Full text] [doi: 10.1186/s12984-016-0204-z] [Medline: 27806718]   
113. Wåhlin A, Fordell H, Ekman U, Lenfeldt N, Malm J. Rehabilitation in chronic spatial neglect strengthens resting-state connectivity. Acta Neurol Scand 2019 Mar;139(3):254-259 [FREE Full text] [doi: 10.1111/ane.13048] [Medline: 30427058]   
114. Celik N, Rohrschneider K. [Electronic vision aids : New options for rehabilitation of the visually impaired]. Ophthalmologe 2018 Jul;115(7):553-558 [FREE Full text] [doi: 10.1007/s00347-017-0644-2] [Medline: 29322255]   
115. Park Y, Lee S, Park J. Recent progress in wireless sensors for wearable electronics. Sensors (Basel) 2019 Oct 09;19(20):4353 [FREE Full text] [doi: 10.3390/s19204353] [Medline: 31600870]   
116. Souza P, Arehart K, Schoof T, Anderson M, Strori D, Balmert L. Understanding variability in individual response to hearing aid signal processing in wearable hearing aids. Ear Hear 2019;40(6):1280-1292 [FREE Full text] [doi: 10.1097/AUD.0000000000000717] [Medline: 30998547]   
117. Paterno L, Ibrahimi M, Gruppioni E, Menciassi A, Ricotti L. Sockets for limb prostheses: a review of existing technologies and open challenges. IEEE Trans Biomed Eng 2018 Sep;65(9):1996-2010 [FREE Full text] [doi: 10.1109/TBME.2017.2775100] [Medline: 29993506]   
118. Segura Anaya LH, Alsadoon A, Costadopoulos N, Prasad PWC. Ethical implications of user perceptions of wearable devices. Sci Eng Ethics 2018 Feb;24(1):1-28 [FREE Full text] [doi: 10.1007/s11948-017-9872-8] [Medline: 28155094]   
119. Lewy H. Wearable technologies - future challenges for implementation in healthcare services. Healthc Technol Lett 2015 Feb;2(1):2-5 [FREE Full text] [doi: 10.1049/htl.2014.0104] [Medline: 26609396]   
120. Yetisen AK, Martinez-Hurtado JL, Ünal B, Khademhosseini A, Butt H. Wearables in medicine. Adv Mater 2018 Jun 11;30(33):e1706910 [FREE Full text] [doi: 10.1002/adma.201706910] [Medline: 29893068]   
121. Dewsbury G, Clarke K, Rouncefield M, Sommerville I. Designing appropriate assistive technology for home users: Developing dependable networks. Presented at: Inclusive Design and Mobility Response in Indoor/Outdoor Public Buildings and Facilities: CIB Working Group W084 – Building Non-Handicapping Environments; October 21-22, 2002; Rome URL: https://tinyurl.com/y3foa8gs   
122. Rodgers MM, Alon G, Pai VM, Conroy RS. Wearable technologies for active living and rehabilitation: current research challenges and future opportunities. J Rehabil Assist Technol Eng 2019;6:2055668319839607. [doi: 10.1177/2055668319839607] [Medline: 31245033]   
123. Cilliers L. Wearable devices in healthcare: privacy and information security issues. Health Inf Manag 2020;49(2-3):150-156 [FREE Full text] [doi: 10.1177/1833358319851684] [Medline: 31146589]   
124. Salim A, Lim S. Recent advances in noninvasive flexible and wearable wireless biosensors. Biosens Bioelectron 2019 Sep 15;141:111422. [doi: 10.1016/j.bios.2019.111422] [Medline: 31229794]   
125. Ling Y, An T, Yap LW, Zhu B, Gong S, Cheng W. Disruptive, soft, wearable sensors. Adv Mater 2020 May 13;32(18):e1904664 [FREE Full text] [doi: 10.1002/adma.201904664] [Medline: 31721340]   
126. Wolf JA, Moreau JF, Akilov O, Patton T, English JC, Ho J, et al. Diagnostic inaccuracy of smartphone applications for melanoma detection. JAMA Dermatol 2013 Apr;149(4):422-426 [FREE Full text] [doi: 10.1001/jamadermatol.2013.2382] [Medline: 23325302]

# Abbreviations

VR: virtual reality   
ECG: electrocardiogram   
COPD: chronic obstructive pulmonary disease

Edited by G Eysenbach; submitted 26.03.20; peer-reviewed by D Cebo, KC Wong; comments to author 20.04.20; revised version received 22.09.20; accepted 24.09.20; published 09.11.20

Please cite as:   
Lu L, Zhang J, Xie Y, Gao F, Xu S, Wu X, Ye Z   
Wearable Health Devices in Health Care: Narrative Systematic Review   
JMIR Mhealth Uhealth 2020;8(11):e18907   
URL: http://mhealth.jmir.org/2020/11/e18907/   
doi: 10.2196/18907   
PMID: